
#ifndef _1_CRYS_ATP_TST_HASH_Acceptance_h_H
#define _1_CRYS_ATP_TST_HASH_Acceptance_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"

#if TST_USE_HASH_DATA/*In case no test vectors are selected - code disabled*/

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 12 12:56:19 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_HASH_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/
typedef struct TST_HASH_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	DxUint8_t 					TST_input_data[TST_HASH_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_input_dataSize;
	CRYS_HASH_Result_t       	TST_HashResultBuff;
	DxUint8_t 					TST_SHA1_Expected_output_data[CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES];
	DxUint16_t					TST_SHA1_Expected_dataSize;	
	DxUint8_t 					TST_MD5_Expected_output_data[CRYS_HASH_MD5_DIGEST_SIZE_IN_BYTES];
	DxUint16_t					TST_MD5_Expected_dataSize;
    DxUint8_t 					TST_SHA224_Expected_output_data[CRYS_HASH_SHA224_DIGEST_SIZE_IN_BYTES];
    DxUint16_t					TST_SHA224_Expected_dataSize;
    DxUint8_t 					TST_SHA256_Expected_output_data[CRYS_HASH_SHA256_DIGEST_SIZE_IN_BYTES];
    DxUint16_t					TST_SHA256_Expected_dataSize;
    DxUint8_t 					TST_SHA384_Expected_output_data[CRYS_HASH_SHA384_DIGEST_SIZE_IN_BYTES];
    DxUint16_t					TST_SHA384_Expected_dataSize;
    DxUint8_t 					TST_SHA512_Expected_output_data[CRYS_HASH_SHA512_DIGEST_SIZE_IN_BYTES];
    DxUint16_t					TST_SHA512_Expected_dataSize;
	CRYS_HASH_OperationMode_t	TST_OperationMode;
} TST_HASH_TestDataStruct;
                       
/******** Public Variables ********/
/******** Public Functions ********/
/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_HASH_Acceptance_NON_integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for HASH non integrated API's							
 * 	This function HASH known vectors using SHA1\SHA224\SHA256\SHA384\SHA512 and MD5
 * 	Vector sizes used (in bytes) - 16/32/512									
 * Algorithm:		
 * 1. Call the CRYS_HASH_Init function to start the encryption/decryption process
 * 2. Call the CRYS_HASH_Update - This function is called N times
 *                                (N = number of blocks in data each block is 16byte)
 * 3. Call the CRYS_HASH_Finish to end the HASH process and get the Digest result
 * 4. Compare the outputted result to the expected one													
 *
 **************************/
CRYSError_t CRYS_ATP_TST_HASH_Acceptance_NON_integrated ( void );

/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_HASH_Acceptance_Integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for HASH integrated API							
 * 	This function HASH known vectors using SHA1 and MD5
 * 	Vector sizes used (in bytes) - 16/32/512/1536														
 * Algorithm:		
 * 1. Call the CRYS_HASH function to use the HASH process
 * 2. Compare the outputted result to the expected one													
 *
 **************************/
CRYSError_t CRYS_ATP_TST_HASH_Acceptance_Integrated ( void );



#ifdef __cplusplus
}
#endif

#endif

#endif

